; ------------------------------------------
; compute phase and magnitude of a (I,Q) vector
; based on CORDIC algo
;
; input : a = I ,b = Q
; output : a = atan(Q/I)/PI b= sqrt(I^2+Q^2)
;
; Copyright : Thierry Leconte 2000
;
; ------------------------------------------


PI  equ 3.14159265358979
cordic_scale equ 0.607252935


cordic
; turn to 2 first quadran
  tst a  
  jge _zero
  tst b
  jlt _turn
  neg	a
  move	a,y0		; y0 = -I
  move  b,x0  		; x0 = Q
  move #-0.5,a  	; a = -PI/2
  jmp _ini
_turn
  move a,y0		; y0 = I
  neg  b
  move b,x0		; x0 = -Q
  move #0.5,a 		; a = +PI/2
  jmp _ini
_zero
  move a,x0  		; x0 = I
  move b,y0  		; y0 = Q
  clr a  ;  a = 0

_ini
  move #shifttab,r0
  move #atantab,r1
  move #cordic_scale,y1

  mpy x0,y1,b
  move b,x0
  mpy y0,y1,b
  move b,y0

  do #23,_end_loop	; could be set lower if less precision needed

  tst b
  jlt _rotplus

  move x0,b	
  move x:(r0)+,y1
  macr y0,y1,b
  move b,x1
  move y0,b
  macr -x0,y1,b x:(r1)+,y1
  sub y1,a b,y0
  jmp _end

_rotplus
  move x0,b
  move x:(r0)+,y1
  macr -y0,y1,b
  move b,x1
  move y0,b
  macr x0,y1,b x:(r1)+,y1
  add y1,a b,y0

_end
 move x1,x0

_end_loop
  move x0,b
  ; a = Atan(Q/I)
  ; b= sqrt(I^2+Q^2)
  rts

	org	x:

shifttab
	dc 0.9999999,@POW(2,-1),@POW(2,-2),@POW(2,-3)
	dc @POW(2,-4),@POW(2,-5),@POW(2,-6),@POW(2,-7)
	dc @POW(2,-8),@POW(2,-9),@POW(2,-10),@POW(2,-11)
	dc @POW(2,-12),@POW(2,-13),@POW(2,-14),@POW(2,-15)
	dc @POW(2,-16),@POW(2,-17),@POW(2,-18),@POW(2,-19)
	dc @POW(2,-20),@POW(2,-21),@POW(2,-22),@POW(2,-23)

atantab
	dc	@ATN(@POW(2,0))/PI,@ATN(@POW(2,-1))/PI,@ATN(@POW(2,-2))/PI,@ATN(@POW(2,-3))/PI
	dc	@ATN(@POW(2,-4))/PI,@ATN(@POW(2,-5))/PI,@ATN(@POW(2,-6))/PI,@ATN(@POW(2,-7))/PI
	dc	@ATN(@POW(2,-8))/PI,@ATN(@POW(2,-9))/PI,@ATN(@POW(2,-10))/PI,@ATN(@POW(2,-11))/PI
	dc	@ATN(@POW(2,-12))/PI,@ATN(@POW(2,-13))/PI,@ATN(@POW(2,-14))/PI,@ATN(@POW(2,-15))/PI
	dc	@ATN(@POW(2,-16))/PI,@ATN(@POW(2,-17))/PI,@ATN(@POW(2,-18))/PI,@ATN(@POW(2,-19))/PI
	dc	@ATN(@POW(2,-20))/PI,@ATN(@POW(2,-21))/PI,@ATN(@POW(2,-22))/PI

