/* Symbol table support
   Copyright (C) 1998 James Bowman

This file is part of gpasm.

gpasm is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

gpasm is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with gpasm; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#if !defined(__SYMBOL_H)
#define __SYMBOL_H

struct symbol {
  char *name;
  void *annotation;
  struct symbol *next;
};

struct symbol_table *push_symbol_table(struct symbol_table *, int case_insensitive);
struct symbol_table *pop_symbol_table(struct symbol_table *);

struct symbol *add_symbol(struct symbol_table *, char *name);
struct symbol *get_symbol(struct symbol_table *, char *name);

void annotate_symbol(struct symbol *, void *);

char *get_symbol_name(struct symbol *);
void *get_symbol_annotation(struct symbol *);

void dump_symbol_table(struct symbol_table *);

void sym_init(void);
void sym_close(void);
void sym_line(char *);
void sym_emit(unsigned int);

#endif
