; Implements special instruction mnemonics
;  Copyright (C) 1998 James Bowman
; 
; This file is part of gpasm.
; 
; gpasm is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation; either version 2, or (at your option)
; any later version.
; 
; gpasm is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
; 
; You should have received a copy of the GNU General Public License
; along with gpasm; see the file COPYING.  If not, write to
; the Free Software Foundation, 59 Temple Place - Suite 330,
; Boston, MA 02111-1307, USA.


; Add carry to file
addcf	macro	f,d
	btfsc	3,0
	incf	f,d
	endm

; Add digit carry to file
adddcf	macro	f,d
	btfsc	3,1
	incf	f,d
	endm

; Branch
b	macro	k
	goto	k
	endm

; Branch on carry
bc	macro	k
	btfsc	3,0
	goto	k
	endm

; Branch on digit carry
bdc	macro	k
	btfsc	3,1
	goto	k
	endm

; Branch on zero
bz	macro	k
	btfsc	3,2
	goto	k
	endm

; Branch on no carry
bnc	macro	k
	btfss	3,0
	goto	k
	endm

; Branch on no digit carry
bndc	macro	k
	btfss	3,1
	goto	k
	endm

; Branch on no zero
bnz	macro	k
	btfss	3,2
	goto	k
	endm

; Clear carry
clrc	macro
	bcf	3,0
	endm

; Clear digit carry
clrdc	macro
	bcf	3,1
	endm

; Clear z
clrz	macro
	bcf	3,2
	endm

; Set carry
setc	macro
	bsf	3,0
	endm

; Set digit carry
setdc	macro
	bsf	3,1
	endm

; Set z
setz	macro
	bsf	3,2
	endm

lcall	macro	k
	call	k
	endm

lgoto	macro	k
	goto	k
	endm

; Move file to w
movfw	macro	f
	movf	f,0
	endm

; Negate
negf	macro	f,d
	comf	f,1
	incf	f,d
	endm

; Skip on carry
skpc	macro
	btfss	3,0
	endm

; Skip on digit carry
skpdc	macro
	btfss	3,1
	endm

; Skip on zero
skpz	macro
	btfss	3,2
	endm

; Skip on no carry
skpnc	macro
	btfsc	3,0
	endm

; Skip on no digit carry
skpndc	macro
	btfsc	3,1
	endm

; Skip on no zero
skpnz	macro
	btfsc	3,2
	endm

; Subtract carry from file
subcf	macro	f,d
	btfsc	3,0
	decf	f,d
	endm

; Subtract digit carry from file
subdcf	macro	f,d
	btfsc	3,1
	decf	f,d
	endm

; Test file
tstf	macro	f
	movf	f,1
	endm
