/* PIC Processor selection
   Copyright (C) 1998 James Bowman

This file is part of gpasm.

gpasm is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

gpasm is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with gpasm; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#ifndef __PROCESSOR_H__
#define __PROCESSOR_H__

void select_processor(char *name);
void dump_processor_list(void);

/* XXXPRO: Need to add an entry for any extra processors.  Please keep
   this list sorted! */

enum pic_processor {
  no_processor,
  generic,
  pic12c508,
  pic12c509,
  pic16c54,
  pic16c55,
  pic16c56,
  pic16c57,
  pic16c58,
  pic16c62,
  pic16c63,
  pic16c64,
  pic16c65,
  pic16c71,
  pic16c74,
  pic16c83,
  pic16f83,
  pic16c84,
  pic16f84,
  pic16f877,
  pic18cxx2,
  pic18c242,
  pic18c252,
  pic18c442,
  pic18c452,
  sx18,
  sx20,
  sx28
};

#define MAX_NAMES 3 /* Maximum number of names a processor can have */

struct px {
  enum pic_processor tag;
  char *defined_as;
  char *names[MAX_NAMES];
};

/* Flag that's true if a the processor has a 16bit core */
extern int _16bit_core;
#endif

