/* PIC Processor selection
   Copyright (C) 1998 James Bowman

This file is part of gpasm.

gpasm is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

gpasm is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with gpasm; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#include "stdhdr.h"

#include "gpasm.h"
#include "symbol.h"
#include "gperror.h"

/*#define MAX_NAMES 3 /* Maximum number of names a processor can have */

/*struct px {
  enum pic_processor tag;
  char *define;
  char *names[MAX_NAMES];
};

/* XXXPRO: Need to add a line here for any extra processors.  Please
   keep this list sorted! */

static struct px pics[] = {
  { generic, "__GEN", { "generic",  "gen", "unknown" } },
  { pic12c508, "__12C508", { "pic12c508",  "p12c508", "12c508" } },
  { pic12c509, "__12C509", { "pic12c509",  "p12c509", "12c509" } },
  { pic16c54, "__16C54", { "pic16c54",  "p16c54", "16c54" } },
  { pic16c55, "__16C55", { "pic16c55",  "p16c55", "16c55" } },
  { pic16c56, "__16C56", { "pic16c56",  "p16c56", "16c56" } },
  { pic16c57, "__16C57", { "pic16c57",  "p16c57", "16c57" } },
  { pic16c58, "__16C58", { "pic16c58",  "p16c58", "16c58" } },
  { pic16c62, "__16C62", { "pic16c62",  "p16c62", "16c62" } },
  { pic16c63, "__16C63", { "pic16c63",	"p16c63", "16c63" } },
  { pic16c64, "__16C64", { "pic16c64",	"p16c64", "16c64" } },
  { pic16c65, "__16C65", { "pic16c65",	"p16c65", "16c65" } },
  { pic16c71, "__16C71", { "pic16c71",	"p16c71", "16c71" } },
  { pic16c74, "__16C74", { "pic16c74",	"p16c74", "16c74" } },
  { pic16c83, "__16C83", { "pic16c83",	"p16c83", "16c83" } },
  { pic16f83, "__16F83", { "pic16f83",  "p16f83", "16f83" } },
  { pic16c84, "__16C84", { "pic16c84",	"p16c84", "16c84" } },
  { pic16f84, "__16F84", { "pic16f84",  "p16f84", "16f84" } },
  { pic16f877,"__16F877",{ "pic16f877", "p16f877","16f877"} },
  { pic18cxx2,"__18cxx2",{ "pic18cxx2", "p18cxx2","18cxx2"} },
  { pic18c242,"__18c242",{ "pic18c242", "p18c242","18c242"} },
  { pic18c252,"__18c252",{ "pic18c252", "p18c252","18c252"} },
  { pic18c442,"__18c442",{ "pic18c442", "p18c442","18c442"} },
  { pic18c452,"__18c452",{ "pic18c452", "p18c452","18c452"} },
  { sx18, "__SX18", { "sx18ac", "sx18", "sx18" } },
  { sx20, "__SX20", { "sx20ac", "sx20", "sx20" } },
  { sx28, "__SX28", { "sx28ac", "sx28", "sx28" } }
};

#define NUM_PICS	(sizeof(pics) / sizeof(pics[0]))

/*
 * Display a list of the processor names
 */
void dump_processor_list(void)
{
#define COLUMNS  6
#define SPACE_BETWEEN 2   /* number of chars between columns */
#define FAVORITE 1        /* there are 3 names to choose from */

  int i,j,k,l,longest;

  
  for(i=0,longest=0; i<NUM_PICS; i++) {
    k = strlen(pics[i].names[FAVORITE]);
    if(k>longest)
      longest = k;
  }

  k=0;

  do {

    for(i=0; (i<COLUMNS) && (k<NUM_PICS); i++) {

      printf("%s",pics[k].names[FAVORITE]);
      if(i<(COLUMNS-1)) {
	l = longest + SPACE_BETWEEN - strlen(pics[k].names[FAVORITE]);
	for(j=0; j<l; j++)
	  putchar(' ');
      }
      k++;
    }
    putchar('\n');
  } while (k < NUM_PICS);
}


void select_processor(char *name)
{
  int i, j;
  struct px *found = NULL;

  for (i = 0; i < NUM_PICS; i++) {
    for (j = 0; (j < MAX_NAMES) && (pics[i].names[j] != NULL); j++) {
      if (strcasecmp(name, pics[i].names[j]) == 0) {
	found = &pics[i];
      }
    }
  }
  if (found) {
    if (state.processor == none) {
      state.processor = found->tag;
      state.processor_info = found;
      add_symbol(state.stDefines, found->defined_as);
    } else if (state.processor != found->tag ) {
      gperror(121, "Processor already selected");
    }
  } else {
    if(state.pass)
      gperror(122, "Unrecognised processor");
    else {
      printf("didn't find any processor named: %s\nHere are the supported processors\n",name);
      dump_processor_list();
      exit(1);
    }
  }
}

