/* i_memory - instruction memory header file.

   Copyright (C) 1999-2000 James Bowman, Scott Dattalo

This file is part of gpasm.

gpasm is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

gpasm is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with gpasm; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#ifndef __I_MEMORY_H__
#define __I_MEMORY_H__

#define MAX_RAM		0x1000	        /* Maximum RAM */
#define I_MEM_BITS      16
#define MAX_I_MEM	(1<<I_MEM_BITS) /* Maximum instruction memory */
#define I_MEM_MASK      (MAX_I_MEM-1)

#define MAX_C_MEM       0x100           /* Maximum configuration memory (only a few bytes are used) */

typedef struct MemBlock {
  unsigned int base;
  unsigned int *memory;
  struct MemBlock *next;
} MemBlock;

void i_memory_create(void);
void i_memory_free(void);
int i_memory_get(unsigned int address);
void i_memory_put(unsigned int address, unsigned int value);
void print_i_memory(void);

#endif
