;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; FAIRCHILD SEMICONDUCTOR, MEMORY PRODUCTS GROUP
;;
;; SAMPLE CODE FOR 4 BYTE BINARY SUBTRACTION USING ACEx.
;;
;; NUM1 = ROM TABLE[07-04], STORED INTO RAM[03-00]
;; NUM2 = ROM TABLE[03-00]
;; RESULT = RAM[10-13]
;; BORROW = RAM[14]
;;
;;      [07] [06] [05] [04]	(ROM TABLE)
;;   -  [03] [02] [01] [00]	(RAM)
;;      -------------------
;; [14] [13] [12] [11] [10]	(RAM)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


; Source code compatible to both ACE1101 and ACE1202.
;.DEVICE ACE1101
.DEVICE ACE1202


OFFSET	EQU	04H	; Address offset between NUM1 and NUM2

; NUM1 RAM LOCATIONS
RAM0	EQU	00H	; LSB of NUM1
RAM1	EQU	01H
RAM2	EQU	02H
RAM3	EQU	03H	; MSB of NUM1

; RESULT RAM LOCATIONS
RAM4	EQU	10H	; LSB of RESULT
RAM5	EQU	11H
RAM6	EQU	12H
RAM7	EQU	13H	; MSB of RESULT

BRWO	EQU	14H	; RAM address of borrow byte


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; MAIN ROUTINE
;;
;; Read NUM1 from ROM TABLE (code EEPROM) and store in RAM
;; Read NUM2 directly from ROM TABLE without storing in RAM
;; NUM2 RAM[3-0]= C7C6C5C4, NUM1 ROM_TABLE[B-8]= C3C2C1C0
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

INIT:	LD	X, #ROM_TABLE	; X points to ROM TABLE
	CLR	BRWO		; Clear RAM[14] for borrow
	JSR	SUB4T		; Perform subtraction
DONE:	JP	DONE		; Subtraction complete


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; SUBROUTINE:  4 Byte Subtraction
;;
;; NUM2 - NUM1 = OVERFLOW, RESULT => RAM[14], RAM[13-10]
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

SUB4T:	LD	A, [#OFFSET,X]	; Store NUM1 into RAM
	ST	A, RAM0
	LD	A, [#OFFSET+1,X]
	ST	A, RAM1
	LD	A, [#OFFSET+2,X]
	ST	A, RAM2
	LD	A, [#OFFSET+3,X]
	ST	A, RAM3

	RC			; Clear carry flag
	LD	A, [#00,X]
	SUBC	A, RAM0		; Subtract ROM[00] - ROM[04]
	ST	A, RAM4		; Store result
	LD	A, [#01,X]	; Subtract ROM[01] - ROM[05]
	SUBC	A, RAM1
	ST	A, RAM5		; Store result
	LD	A, [#02,X]	; Subtract ROM[02] - ROM[06]
	SUBC	A, RAM2
	ST	A, RAM6		; Store result
	LD	A, [#03,X]	; Subtract ROM[03] - ROM[07]
	SUBC	A, RAM3
	ST	A, RAM7		; Store result
	RLC	BRWO		; Rotate carry in borrow
	RET			; Subtraction complete...


;ROM[00-07]
ROM_TABLE:
	DB	0C4H		; ROM[00], NUM2 LSB
	DB	0C5H		; ROM[01]
	DB	0C6H		; ROM[02]
	DB	0C7H		; ROM[03], NUM2 MSB
	DB	0C0H		; ROM[04], NUM1 LSB
	DB	0C1H		; ROM[05]
	DB	0C2H		; ROM[06]
	DB	0C3H		; ROM[07], NUM1 MSB


	END			; End assembly source file
