;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; FAIRCHILD SEMICONDUCTOR, MEMORY PRODUCTS GROUP
;;
;; SAMPLE CODE FOR 8 BIT MULTIPLICATION USING ACEx.
;;
;; ICAND X IER  = RESULT HI, RESULT LOW
;; [00]  X [01] = [03]     , [02]
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


; SOURCE CODE IS COMPATIBLE TO BOTH ACE1101 AND ACE1202
;.DEVICE ACE1101
.DEVICE ACE1202


ICAND		EQU	00H	; MULTIPLICAND
IER		EQU	01H	; MULTIPLIER
PROD_LO		EQU	02H	; LOW BYTE OF RESULT
PROD_HI		EQU	03H	; HIGH BYTE OF RESULT

PPROD_LO	EQU	04H	; LOW BYTE OF PARTIAL PRODUCT
PPROD_HI	EQU	05H	; HIGH BYTE OF PARTIAL PRODUCT

BIT_PTR		EQU	06H	; BIT POINTER FOR MULTIPLIER


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; MAIN ROUTINE
;;
;; PLACE ICAND AND IER INTO RAM.
;; ICAND RAM[00]= E7, IER RAM[01]= 3D
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

INIT:	CLR	A		; CLEAR ACCUM
	CLR	BIT_PTR		; CLEAR RAM
	CLR	PROD_LO		;
	CLR	PROD_HI		;
	CLR	PPROD_LO	;
	CLR	PPROD_HI	;
	LD	ICAND, #0E7H	; STORE MULTIPLICAND IN RAM
	LD	IER, #03DH	; STORE MULTIPLIER IN RAM
	JSR	MPY88		; PERFORM MULTIPLICATION
DONE:	JP	DONE		; MULTIPLICATION COMPLETE


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; SUBROUTINE:  8 BIT MULTIPLICATION
;;
;; ICAND X IER = RESULT, RESULT => RAM[3], RAM[2]
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

MPY88:	RRC	IER		; SHIFT LSB OF MULTIPLIER INTO CARRY
	IFC			; IS LSB = 1 ? 
	JSR	MPY88PP		; YES, PERFORM PARTIAL PRODUCT ADDITION
	INC	BIT_PTR		; NO, INCREMENT BIT POINTER TO NEXT LOCATION
	IFEQ	BIT_PTR, #08H	; HAVE WE COMPLETED THE MULTIPLICATION
				; OF ALL 8 BITS?
	JP	MPY88D		; YES, MULTIPLICATION COMPLETE
	JP	MPY88		; NO, NEXT BIT
MPY88D:	RET			; MULTIPLICATION COMPLETE...


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; SUBROUTINE:  PARTIAL PRODUCT ADDITION
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

MPY88PP:
	LD	PPROD_LO, ICAND	; LOAD MULTIPLICAND INTO PARTICAL PRODUCT
	CLR	PPROD_HI	; CLEAR HIGH BYTE OF PARTICAL PRODUCT
	LD	A, BIT_PTR	; BIT POINTER IS NOW THE NUMBER OF TIME TO
				; SHIFT THE PARTIAL PRODUCT
SHIFT:	IFEQ	A, #00H		; IS IT THE LAST SHIFT?
	JP	ADD2RSLT	; YES, ADD PARTIAL PRODUCT TO RESULT
	RC			; NO, CLEAR CARRY FLAG
	DEC	A		; DECREMENT COUNT
	RLC	PPROD_LO	; SHIFT PARTICAL PRODUCT LEFT ONCE
	RLC	PPROD_HI	; ROTATING THROUGH THE CARRY FLAG
	JP	SHIFT		; NEXT SHIFT
ADD2RSLT: 
	RC			; CLEAR CARRY
	LD	A, PPROD_LO	; ADD PARTIAL PRODUCT TO RESULT
	ADC	A, PROD_LO	;
	ST	A, PROD_LO	;
	LD	A, PPROD_HI	;
	ADC	A, PROD_HI	;
	ST	A, PROD_HI	;
	RET			; PARTIAL PRODUCT ADDITION COMPLETE...

	END			; END ASSEMBLY SOURCE CODE FILE