;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; FAIRCHILD SEMICONDUCTOR, MEMORY PRODUCTS GROUP
;;
;; SAMPLE CODE FOR 8 BIT DIVISION USING ACEx.
;;
;; IDEND / ISOR = QUOT, REM
;; [00]  / [01] = [03], [02]
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


; SOURCE CODE IS COMPATIBLE TO BOTH ACE1101 AND ACE1202
;.DEVICE ACE1101
.DEVICE ACE1202


IDEND	EQU	00H	; RAM ADDRESS OF DIVIDEND
ISOR	EQU	01H	; RAM ADDRESS OF DIVISOR

QUOT	EQU	02H	; RAM ADDRESS OF QUOTIENT
REM	EQU	03H	; RAM ADDRESS OF REMAINDER

TEMP	EQU	04H	; TEMPORARY RAM ADDRESS LOCATION FOR TEST DIVIDEND


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; MAIN ROUTINE
;;
;; PLACE IDEND AND ISOR INTO RAM.
;; IDEND RAM[00]= E7, ISOR RAM[01]= 3D
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

INIT:	CLR	QUOT		; CLEAR RAM
	CLR	REM		; CLEAR RAM
	CLR	X		; TRACKS NUMBER OF SHIFTS PERFORMED TO DIVIDEND

	LD	IDEND, #0E7H	; LOADS DIVIDEND WITH VALUE
	LD	ISOR, #03DH	; LOADS DIVISOR WITH VALE
	RC			; CLEAR CARRY FLAG
	LD	TEMP, IDEND	; STORE DIVIDEN INTO TEMP LOCATION
	JSR	DIV88		; PERFORM DIVISION
DONE:	JP	DONE		; DIVISION COMPLETE


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; SUBROUTINE:  8 BIT DIVISION
;;
;; IDEND / ISOR = QUOT AND REM => RAM[02], RAM[03]
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

DIV88:	INC	X		; INCREMENT COUNT
	RLC	TEMP		; ROTATE MSB OF TEMP INTO CARRY
	RLC	REM		; ROTATE CARRY INTO LSB OF REMAINDER
	LD	A, REM
	IFGT	A, ISOR		; IS REM LARGER THAN DIVISOR?
	JP	DIV88S		; YES, DO SUBTRACTION
	IFEQ	A, ISOR		; NO, IS REM EQUAL TO DIVISOR?
	JP	DIV88S		; YES, DO SUBTRACTION
	RC			; NO, CLEAR CARRY FLAG
	RLC	QUOT		; ROTATE CARRY INTO LSB OF QUOTIENT
	IFEQ	X, #08H		; HAVE WE SHIFTED THE LAST BIT OF DIVISOR?
	JP	DIV88D		; YES, DIVISION DONE
	JP	DIV88		; NO, NEXT BIT

DIV88S:	SC			; SET CARRY
	RLC	QUOT		; ROTATE CARRY INTO LSB OF QUOTIENT
	RC			; CLEAR CARRY
	SUBC	A, ISOR		; SUBTRACT DIVISOR FROM REM
	ST	A, REM		; STORE RESULT INTO REM
	IFEQ	X, #08H		; HAVE WE SHIFTED THE LAST BIT OF DIVISOR?
	JP	DIV88D		; YES, DIVISION DONE
	JMP	DIV88		; NO, NEXT BIT

DIV88D:	RET			; DIVISION COMPLETE...

	END			; END ASSEMBLY SOURCE CODE FILE
	
